/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.core.v2_1.graphics;

import com.roguewave.chart.core.v2_1.graphics.Canvas3D;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.RelativePlacement;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

public class TextDevDrawable
implements Drawable,
RelativePlacement,
Serializable {
    String string_;
    int x_;
    int y_;
    int placement_;
    Font font_;
    Color color_;

    public TextDevDrawable(String string, int n, int n2, int n3, Color color, Font font) {
        this.string_ = string;
        this.x_ = n;
        this.y_ = n2;
        this.placement_ = n3;
        this.font_ = font;
        this.color_ = color;
    }

    public void drawOn(Canvas3D canvas3D, Graphics graphics) {
        int n;
        int n2;
        graphics.setFont(this.font_);
        graphics.setColor(this.color_);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.stringWidth(this.string_);
        switch (this.placement_) {
            case 3: {
                n2 = (int)((double)this.x_ - (double)n3 / 2.0 + 0.5);
                n = this.y_;
                break;
            }
            case 0: {
                n2 = (int)((double)this.x_ - (double)n3 / 2.0 + 0.5);
                n = this.y_ + fontMetrics.getHeight() - fontMetrics.getMaxDescent();
                break;
            }
            case 1: {
                n2 = this.x_ - n3;
                n = (int)((double)this.y_ + (double)(fontMetrics.getHeight() - fontMetrics.getMaxDescent()) / 2.0 + 0.5);
                break;
            }
            case 2: {
                n2 = this.x_;
                n = (int)((double)this.y_ + (double)(fontMetrics.getHeight() - fontMetrics.getMaxDescent()) / 2.0 + 0.5);
                break;
            }
            default: {
                System.err.println("TextDevDrawable: Bad or unimplemented placement specification");
                return;
            }
        }
        graphics.drawString(this.string_, n2, n);
    }
}

